import {world, system, Player, Entity, EffectType, EffectTypes} from "@minecraft/server";
import {ModalFormData, MessageFormData, ActionFormData} from "@minecraft/server-ui";

// Texturing
const bases = ["None", "Base 1", "Base 2", "Base 3"];
const legs = ["None", "Student 1", "Student 2", "Fitness 1"];
const tops = ["None", "Student 1", "Student 2", "Fitness 1", "Shirt 1"];
const hairStyles = ["Bald 1", "Shoulder 1", "Boyish 1", "Short 1", "Short 2", "Long 1"];
const hairColor = ["White", "Light Gray", "Gray", "Black", "Brown", "Red", "Orange", "Yellow", "Lime", "Green", "Cyan", "Light Blue", "Blue", "Purple", "Magenta", "Pink"];
const jackets = ["None", "Student 1", "Student 2"];
const hats = ["None", "Crown", "Flower Crown", "Christmas Hat"];
const feet = ["None", "Student 1", "Student 2", "Fitness 1"];
const fulls = ["None", "Red Dress"];

// Modeling
const bodies = ["Default", "Slim", "Small", "Small Slim", "Mid", "Mid Slim", "Cat Wide", "Cat Slim", "Cat Small", "Cat Small Slim", "Cat Mid", "Cat Mid Slim"];

// Menus
let baseMenu = new ActionFormData(); baseMenu.title("Edit Look"); baseMenu.body("Change Base");
let legMenu = new ActionFormData(); legMenu.title("Edit Look"); legMenu.body("Change Legs");
let topMenu = new ActionFormData(); topMenu.title("Edit Look"); topMenu.body("Change Top");
let hairMenu = new ModalFormData(); hairMenu.title("Edit Look"); hairMenu.dropdown("Hair Style", hairStyles, 0); hairMenu.dropdown("Hair Color", hairColor, 0);
let jacketMenu = new ActionFormData(); jacketMenu.title("Edit Look"); jacketMenu.body("Change Jacket");
let hatMenu = new ActionFormData(); hatMenu.title("Edit Look"); hatMenu.body("Change Hat");
let footMenu = new ActionFormData(); footMenu.title("Edit Look"); footMenu.body("Change Feet");
let fullMenu = new ActionFormData(); fullMenu.title("Edit Look"); fullMenu.body("Change Full");
let bodyMenu = new ActionFormData(); bodyMenu.title("Edit Look"); bodyMenu.body("Change Body");


// Build the menus
function buildMenus(){
    world.afterEvents.worldInitialize.subscribe(()=>{
        system.runTimeout(()=>{
            let menus = [baseMenu, legMenu, topMenu, jacketMenu, hatMenu, footMenu, fullMenu, bodyMenu];
            let buttons = [bases, legs, tops, jackets, hats, feet, fulls, bodies];
            let mc = 0;
            while(mc < menus.length){
                let bc = 0;
                while(bc < buttons[mc].length){
                    menus[mc].button(buttons[mc][bc]);
                    bc++
                };
                mc++
            };
        }, 100);
    });
};
system.run(buildMenus);

// Open Menus
system.afterEvents.scriptEventReceive.subscribe((event)=>{
    if(event.id == "jo:chrEditor"){
        if(event.sourceEntity.typeId=="minecraft:player"){
            let buttonMenu = new ActionFormData(); buttonMenu.title("Edit Look"); buttonMenu.body("Select A Part To Change");
            if(event.message=="selector"){
                let selectorMenu = new ModalFormData(); selectorMenu.title("Edit Look");
                let opt = [];
                for(let p = 0; p < world.getAllPlayers().length; p++){
                    opt.push(world.getAllPlayers()[p].name);
                };
                selectorMenu.dropdown("Player to change look's of",opt,0);
                selectorMenu.show(event.sourceEntity).then((resp)=>{
                    if(resp.canceled){return;};
                    let victim = world.getAllPlayers()[resp.formValues[0]];
                    event.sourceEntity.runCommand("scriptevent jo:chrEditor victim_"+victim.name);
                });return;
            }else if(event.message.startsWith("victim_")==true){
                if(!world.getPlayers({name:event.message.split("_")[1]})[0]){return;};
                let victim = world.getPlayers({name:event.message.split("_")[1]})[0];
                let menuNames = ["Base", "Legs", "Top", "Hair", "Jacket", "Hat", "Feet", "Full", "Body"];
                for(let i = 0; i < menuNames.length; i++){
                    buttonMenu.button(menuNames[i]);  
                };
                buttonMenu.show(event.sourceEntity).then((resp)=>{
                    if(resp.canceled){return;};
                    let menus = [baseMenu, legMenu, topMenu, hairMenu, jacketMenu, hatMenu, footMenu, fullMenu, bodyMenu];
                    let player = event.sourceEntity;
                    menus[resp.selection].show(event.sourceEntity).then((resp2)=>{
                        if(resp2.canceled){return;};
                        switch (resp.selection) {
                            case 0: if (resp2.selection == 0) { victim.setProperty("jo:base", 0); return; }; if (victim.getProperty("jo:legs") == 0) { legMenu.show(player).then((res1) => { if (res1.canceled || res1.selection == 0) { return; }; if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) { return; }; victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); victim.setProperty( "jo:top", res2.selection ); }); }else { victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); }; }); } else if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) { return; }; victim.setProperty("jo:base", resp2.selection); victim.setProperty("jo:top", res2.selection); }); } else { victim.setProperty("jo:base", resp2.selection); }; break;
                            case 1: if (resp2.selection == 0) { victim.setProperty("jo:legs", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:legs", resp2.selection); } break;
                            case 2: if (resp2.selection == 0) { victim.setProperty("jo:top", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:top", resp2.selection); } break;
                            case 3: if (resp2.formValues[0] == 0) { victim.setProperty("jo:hairColorStyle", 0); } else { world.sendMessage( (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 + " " ); victim.setProperty( "jo:hairColorStyle", (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 ); } break;
                            case 4: victim.setProperty("jo:jacket", resp2.selection); break;
                            case 5: victim.setProperty("jo:hat", resp2.selection); break;
                            case 6: victim.setProperty("jo:feet", resp2.selection); break;
                            case 7: victim.setProperty("jo:full", resp2.selection); break;
                            case 8: victim.getComponent("mark_variant").value=resp2.selection%2;if(resp2.selection%6==3||resp2.selection%6==4){victim.setProperty("jo:chest", 1)}else if(resp2.selection%6==5||resp2.selection%6==6){victim.setProperty("jo:chest", 2)}; if(resp2.selection>=6){victim.setProperty("jo:isCat", true)}else {victim.setProperty("jo:isCat", false)}; break;
                            default: return;
                          };
                    });
                });
            }else if(event.message=="self"){
                let victim = event.sourceEntity;
                let player = event.sourceEntity;
                let menuNames = ["Base", "Legs", "Top", "Hair", "Jacket", "Hat", "Feet", "Full", "Body"];
                for(let i = 0; i < menuNames.length; i++){
                    buttonMenu.button(menuNames[i]);  
                };
                buttonMenu.show(player).then((resp)=>{
                    if(resp.canceled){return;};
                    let menus = [baseMenu, legMenu, topMenu, hairMenu, jacketMenu, hatMenu, footMenu, fullMenu, bodyMenu];
                    menus[resp.selection].show(player).then((resp2)=>{
                        if(resp2.canceled){return;};
                        switch (resp.selection) {
                          case 0: if (resp2.selection == 0) { victim.setProperty("jo:base", 0); return; }; if (victim.getProperty("jo:legs") == 0) { legMenu.show(player).then((res1) => { if (res1.canceled || res1.selection == 0) { return; }; if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) { return; }; victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); victim.setProperty( "jo:top", res2.selection ); }); }else { victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); }; }); } else if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) { return; }; victim.setProperty("jo:base", resp2.selection); victim.setProperty("jo:top", res2.selection); }); } else { victim.setProperty("jo:base", resp2.selection); }; break;
                          case 1: if (resp2.selection == 0) { victim.setProperty("jo:legs", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:legs", resp2.selection); } break;
                          case 2: if (resp2.selection == 0) { victim.setProperty("jo:top", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:top", resp2.selection); } break;
                          case 3: if (resp2.formValues[0] == 0) { victim.setProperty("jo:hairColorStyle", 0); } else { world.sendMessage( (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 + " " ); victim.setProperty( "jo:hairColorStyle", (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 ); } break;
                          case 4: victim.setProperty("jo:jacket", resp2.selection); break;
                          case 5: victim.setProperty("jo:hat", resp2.selection); break;
                          case 6: victim.setProperty("jo:feet", resp2.selection); break;
                          case 7: victim.setProperty("jo:full", resp2.selection); break;
                          case 8: victim.getComponent("mark_variant").value=resp2.selection%2;if(resp2.selection%6==3||resp2.selection%6==2){victim.setProperty("jo:chest", 1)}else if(resp2.selection%6==5||resp2.selection%6==4){victim.setProperty("jo:chest", 2)}else if(resp2.selection%6==1||resp2.selection%6==0){victim.setProperty("jo:chest", 0)}; if(resp2.selection>=6){victim.setProperty("jo:isCat", true)}else {victim.setProperty("jo:isCat", false)}; break;
                          default: return;
                        };
                    });
                });
            }
        }
    }
});

world.afterEvents.playerInteractWithEntity.subscribe((event)=>{
    if(event.target.typeId=="jo:wardrove_chr"){
        event.target.isSneaking = true;
        event.player.camera.fade({fadeColor:{red:0, green: 0, blue:0}, fadeTime: {fadeInTime: 2, fadeOutTime: 2, holdTime: 10}});
        system.runTimeout(()=>{openGardrove(event.player, event.target);}, 40);
    };
});
/**
 * 
 * @param {Player} playerArg 
 * @param {Entity} wardroveArg 
 */
function openGardrove(playerArg, wardroveArg){
    let buttonMenu = new ActionFormData(); buttonMenu.title("Edit Look"); buttonMenu.body("Select A Part To Change");
    let victim = playerArg;
    let player = playerArg;
    let wardrove = wardroveArg;
    player.addEffect("invisibility", 99999, {showParticles: false, amplifier: 1});
    player.addEffect("blindness", 9999999, {showParticles:false, amplifier: 1});
    let menuNames = ["Base", "Legs", "Top", "Hair", "Jacket", "Hat", "Feet", "Full", "Body"];
    for(let i = 0; i < menuNames.length; i++){
        buttonMenu.button(menuNames[i]);  
    };
    buttonMenu.show(player).then((resp)=>{
        if(resp.canceled){player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return;};
        let menus = [baseMenu, legMenu, topMenu, hairMenu, jacketMenu, hatMenu, footMenu, fullMenu, bodyMenu];
        menus[resp.selection].show(player).then((resp2)=>{
            if(resp2.canceled){player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return;};
            switch (resp.selection) {
                case 0: if (resp2.selection == 0) { victim.setProperty("jo:base", 0); openGardrove(player, wardrove); return;}; if (victim.getProperty("jo:legs") == 0) { legMenu.show(player).then((res1) => { if (res1.canceled || res1.selection == 0) {player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return; }; if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) {player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return; }; victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); victim.setProperty( "jo:top", res2.selection ); }); }else { victim.setProperty( "jo:base", resp2.selection ); victim.setProperty( "jo:legs", res1.selection ); }; }); } else if (victim.getProperty("jo:top") == 0) { topMenu.show(player).then((res2) => { if (res2.canceled || res2.selection == 0) {player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return; }; victim.setProperty("jo:base", resp2.selection); victim.setProperty("jo:top", res2.selection); }); } else { victim.setProperty("jo:base", resp2.selection); }; openGardrove(player, wardroveArg); break;
                case 1: if (resp2.selection == 0) { victim.setProperty("jo:legs", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:legs", resp2.selection); }; openGardrove(player, wardroveArg); break;
                case 2: if (resp2.selection == 0) { victim.setProperty("jo:top", 0); victim.setProperty("jo:base", 0); } else { victim.setProperty("jo:top", resp2.selection); }; openGardrove(player, wardroveArg); break;
                case 3: if (resp2.formValues[0] == 0) { victim.setProperty("jo:hairColorStyle", 0); } else { world.sendMessage( (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 + " " ); victim.setProperty( "jo:hairColorStyle", (resp2.formValues[0] - 1) * 16 + resp2.formValues[1] + 1 ); }; openGardrove(player, wardroveArg); break;
                case 4: victim.setProperty("jo:jacket", resp2.selection); openGardrove(player, wardroveArg); break;
                case 5: victim.setProperty("jo:hat", resp2.selection); openGardrove(player, wardroveArg); break;
                case 6: victim.setProperty("jo:feet", resp2.selection); openGardrove(player, wardroveArg); break;
                case 7: victim.setProperty("jo:full", resp2.selection); openGardrove(player, wardroveArg); break;
                case 8: victim.getComponent("mark_variant").value=resp2.selection%2;if(resp2.selection%6==3||resp2.selection%6==4){victim.setProperty("jo:chest", 1)}else if(resp2.selection%6==5||resp2.selection%6==6){victim.setProperty("jo:chest", 2)}; if(resp2.selection>=6){victim.setProperty("jo:isCat", true)}else {victim.setProperty("jo:isCat", false)}; openGardrove(player, wardroveArg); break;
                default: player.removeEffect("blindness");player.removeEffect("invisibility"); wardrove.isSneaking = false; return;
            };
        });
    });
};
world.afterEvents.playerInteractWithEntity.subscribe((ev)=>{
    if(!ev.itemStack){return;};
    if(ev.target.typeId=="jo:npc_human" && ev.itemStack.typeId=="jo:human_editor_tool"){
        system.runTimeout(()=>{

            let npc = ev.target;
            let editor = new ModalFormData();
            editor.title("NPC Look Editor")
            editor.textField("Name", "Name of this Human", npc.nameTag);    //0
            editor.toggle("Slim", npc.getComponent("mark_variant").value==1); //1
            editor.toggle("Cat", npc.getProperty("jo:isCat"));  //2
    
            //editor.slider("Hair", 0, hairColor.length*hairStyles.length-16, 1, npc.getProperty("jo:hairColorStyle"));
            editor.dropdown("Hair Style", hairStyles, Math.floor((npc.getProperty("jo:hairColorStyle")/16))+1);   //3
            editor.dropdown("Hair Color", hairColor, Math.floor(npc.getProperty("jo:hairColorStyle")%16)-1);  //4
    
            editor.slider("Base", 0, bases.length-2, 1, npc.getProperty("jo:base"));
            editor.slider("Top", 0, tops.length-2, 1, npc.getProperty("jo:top"));
            editor.slider("Legs", 0, legs.length-2, 1, npc.getProperty("jo:legs"));
            editor.slider("Jacket", 0, jackets.length-1, 1, npc.getProperty("jo:jacket"));
            editor.slider("Hat", 0, hats.length-1, 1, npc.getProperty("jo:hat"));
            editor.slider("Feet", 0, feet.length-1, 1, npc.getProperty("jo:feet"));
            editor.slider("Full", 0, fulls.length-1, 1, npc.getProperty("jo:full"));
            editor.dropdown("Chest", ["Flat", "Small", "Mid"], npc.getProperty("jo:chest"));
            editor.show(ev.player).then((res)=>{
              if (res.canceled) {
                return;
              }
              npc.nameTag = res.formValues[0];
              let slim = npc.getComponent("mark_variant");
              if (res.formValues[1] == true) {
                slim.value = 1;
              } else {
                slim.value = 0;
              }
              //npc.setProperty("jo:chest", res.formValues[2]);
              npc.setProperty("jo:isCat", res.formValues[2]);
              //npc.setProperty("jo:hairColorStyle", res.formValues[4 - 1]);
              if (res.formValues[3] == 0) {
                npc.setProperty("jo:hairColorStyle", 0);
              } else {
                npc.setProperty(
                  "jo:hairColorStyle",
                  (res.formValues[3] - 1) * 16 + res.formValues[4] + 1
                );
              };
              npc.setProperty("jo:base", res.formValues[5]);
              npc.setProperty("jo:top", res.formValues[6]);
              npc.setProperty("jo:legs", res.formValues[7]);
              npc.setProperty("jo:jacket", res.formValues[8]);
              npc.setProperty("jo:hat", res.formValues[9]);
              npc.setProperty("jo:feet", res.formValues[10]);
              npc.setProperty("jo:full", res.formValues[11]);
              npc.setProperty("jo:chest", res.formValues[12]);
              let n = npc.getComponent("minecraft:npc");
              n.name = res.formValues[0];
              return;
            })
        }, 60)
    }else {
        return;
    }
})